<?php
// Enable error reporting for debugging purposes
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Include database connection file
include 'db.php';

// Set headers for JSON response
header('Content-Type: application/json');

// Retrieve the JSON request body
$json = file_get_contents('php://input');
$data = json_decode($json, true);

// Check if the JSON data is valid
if (json_last_error() !== JSON_ERROR_NONE) {
    echo json_encode([
        "ResponseCode" => "02",
        "ResponseMessage" => "Invalid JSON data"
    ]);
    exit;
}

// Check if all required parameters are provided
if (!isset($data['mobile']) || !isset($data['username']) || !isset($data['post'])) {
    echo json_encode([
        "ResponseCode" => "03",
        "ResponseMessage" => "Missing parameters"
    ]);
    exit;
}

// Extract data from the JSON object
$mobile = $data['mobile'];
$username = $data['username'];
$post = $data['post'];
 $post_like= '0';
 
 

//$check_user_stmt->close();

// Prepare the SQL statement to insert the new user
$insert_stmt = $conn->prepare("INSERT INTO posts (mobile, username, post,post_time, post_like) VALUES (?, ?, ?, NOW(),?)");
if (!$insert_stmt) {
    echo json_encode([
        "ResponseCode" => "01",
        "ResponseMessage" => "Preparation of the insert statement failed: " . $conn->error
    ]);
    exit;
}

// Bind parameters
$insert_stmt->bind_param("ssss", $mobile, $username, $post,$post_like);

// Execute the insert statement and check for errors
if ($insert_stmt->execute()) {
    $query = "SELECT post_id, post,post_time,post_like FROM posts WHERE (mobile = ? ) LIMIT 1";
$check_user_stmt1 = $conn->prepare($query);
    $check_user_stmt1->bind_param("s", $mobile);
    $check_user_stmt1->execute();
    $check_user_stmt1->bind_result($post_id,$post,$post_time,$post_like);
    
    if ($check_user_stmt1->fetch()) {
     echo json_encode([
            "ResponseCode" => "00",
            "ResponseMessage" => "post added successfully"
            // ,
            //  "id" => $post_id,
            // "post" => $post, 
            //  "post_time" => $post_time,
            //  "post_like" => $post_like,
            // "mobile" => $mobile
        ]);
    
    }
    
    // echo json_encode([
    //     "ResponseCode" => "00",
    //     "ResponseMessage" => "successful"
    // ]);
} else {
    echo json_encode([
        "ResponseCode" => "01",
        "ResponseMessage" => "Insert failed: " . $insert_stmt->error
    ]);
}

$insert_stmt->close();
$conn->close();
?>