<?php
// Enable error reporting for debugging purposes
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Include database connection file
include 'db.php';

// Set headers for JSON response
header('Content-Type: application/json');

// Retrieve the JSON request body
$json = file_get_contents('php://input');
$data = json_decode($json, true);

// Check if the JSON data is valid
if (json_last_error() !== JSON_ERROR_NONE) {
    echo json_encode([
        "ResponseCode" => "02",
        "ResponseMessage" => "Invalid JSON data"
    ]);
    exit;
}

// Check if 'mobile' and 'otp' parameters are provided
if (!isset($data['mobile']) || !isset($data['username'])|| !isset($data['tagline'])|| !isset($data['profilepics'])) {
    echo json_encode([
        "ResponseCode" => "03",
        "ResponseMessage" => "Missing parameters"
    ]);
    exit;
}

// Extract data from the JSON object
$mobile = $data['mobile'];
$username = $data['username'];
$tagline = $data['tagline'];
$profilepics = $data['profilepics'];

// Prepare the SQL statement to validate OTP
$stmt = $conn->prepare("SELECT id FROM users WHERE mobile = ? ");

// Check if the statement was prepared successfully
if (!$stmt) {
    echo json_encode([
        "ResponseCode" => "01",
        "ResponseMessage" => "Preparation of the statement failed: " . $conn->error
    ]);
    exit;
}

// Bind parameters
$stmt->bind_param("s", $mobile);

// Execute the statement
$stmt->execute();

// Store the result
$stmt->store_result();

// Check if an OTP record was found
if ($stmt->num_rows > 0) {
    // Mark the OTP as used (active = 1)
    $stmt_update = $conn->prepare("UPDATE users SET username ='$username' , tagline ='$tagline', profile_picture ='$profilepics' WHERE mobile = ? ");
    $stmt_update->bind_param("s", $mobile);
    $stmt_update->execute();
    $stmt_update->close();

    echo json_encode([
        "ResponseCode" => "00",
        "ResponseMessage" => "successful"
    ]);
} else {
    echo json_encode([
        "ResponseCode" => "01",
        "ResponseMessage" => "Username update failed"
    ]);
}

$stmt->close();
$conn->close();
?>