<?php
/*

API to fetch all articles from the article table
*/

// Enable error reporting for debugging purposes
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Include database connection file
include 'db.php';  // Ensure you have your database connection in 'db.php'

// Set headers for JSON response
header('Content-Type: application/json');

// Retrieve the JSON request body
$json = file_get_contents('php://input');
//$data = json_decode($json, true);

// Check if the JSON data is valid
if (json_last_error() !== JSON_ERROR_NONE) {
    echo json_encode([
        "ResponseCode" => "02",
        "ResponseMessage" => "Invalid JSON data"
    ]);
    exit;
}

//Check if the email field is present
// if (!isset($data['mobile'])) {
//     echo json_encode([
//         "ResponseCode" => "03",
//         "ResponseMessage" => "Missing 'email' parameter"
//     ]);
//     exit;
// }

// Get the email from the request
 //$mobile= $data['mobile'];

// Prepare the SQL query to get the last 10 transactions based on email
$query = "SELECT article, article_time, username, article_like 
          FROM articles  
          
          ORDER BY article_time DESC";

$stmt = $conn->prepare($query);
//$stmt->bind_param("s", $mobile);
$stmt->execute();

// Get the result
$result = $stmt->get_result();

// Check if any articles are found
if ($result->num_rows > 0) {
    $articles = [];

    // Fetch all the rows as an associative array
    while ($row = $result->fetch_assoc()) {
        $articles[] = $row;
    }

    // Return the transactions in the response
    echo json_encode([
        "ResponseCode" => "00",
        "ResponseMessage" => "Success",
        "article" => $articles
    ]);
} else {
    // If no transactions found, return an empty list
    echo json_encode([
        "ResponseCode" => "01",
        "ResponseMessage" => "No articles found",
        "articles" => []
    ]);
}

// Close the statement and connection
$stmt->close();
$conn->close();
?>
