<?php
// Enable error reporting for debugging purposes
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Include database connection file
include 'db.php';

// Set headers for JSON response
header('Content-Type: application/json');

// Retrieve the JSON request body
$json = file_get_contents('php://input');
$data = json_decode($json, true);

// Check if the JSON data is valid
if (json_last_error() !== JSON_ERROR_NONE) {
    echo json_encode([
        "ResponseCode" => "02",
        "ResponseMessage" => "Invalid JSON data"
    ]);
    exit;
}

// Check if the 'mobile' parameter is provided
if (!isset($data['mobile'])) {
    echo json_encode([
        "ResponseCode" => "03",
        "ResponseMessage" => "Missing parameters"
    ]);
    exit;
}

// Extract the mobile number from the JSON object
$mobile = $data['mobile'];

// Prepare the SQL statement to check if the mobile number exists
$query = "SELECT COUNT(*) FROM users WHERE mobile = ?";
$check_mobile_stmt = $conn->prepare($query);
if (!$check_mobile_stmt) {
    echo json_encode([
        "ResponseCode" => "01",
        "ResponseMessage" => "Preparation of the mobile check statement failed: " . $conn->error
    ]);
    exit;
}

// Bind the parameter
$check_mobile_stmt->bind_param("s", $mobile);

// Execute the statement
$check_mobile_stmt->execute();

// Bind the result
$check_mobile_stmt->bind_result($count);

// Fetch the result
$check_mobile_stmt->fetch();

if ($count > 0) {
    echo json_encode([
        "ResponseCode" => "00",
        "ResponseMessage" => "Mobile number exists"
    ]);
} else {
    echo json_encode([
        "ResponseCode" => "01",
        "ResponseMessage" => "Mobile number does not exist"
    ]);
}

$check_mobile_stmt->close();
$conn->close();
?>