<?php
// Database connection
include ("db.php");

if ($conn->connect_error) {
    die(json_encode([
        "ResponseCode" => "01",
        "ResponseMessage" => "Database connection failed"
    ]));
}

// Set headers to accept JSON and return JSON
header("Content-Type: application/json");

// Get the JSON request
$data = json_decode(file_get_contents("php://input"), true);

// Check if JSON decoding was successful
if (!$data) {
    echo json_encode([
        "ResponseCode" => "02",
        "ResponseMessage" => "Invalid JSON format"
    ]);
    exit;
}

// Prepare and bind the SQL insert statement
$sql = "INSERT INTO customers (firstName, lastName, middleName, birthDate, address, town, city, phone_number, gender, branch,maritalStatus,  bvn,accountType,state)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
$stmt = $conn->prepare($sql);

if (!$stmt) {
    echo json_encode([
        "ResponseCode" => "03",
        "ResponseMessage" => "Database error: " . $conn->error
    ]);
    exit;
}

// Bind parameters
$stmt->bind_param(
    "sssssssssssiss",
    $data['firstName'],
    $data['lastName'],
    $data['middleName'],
    $data['birthDate'],
    $data['address'],
    $data['town'],
    $data['city'],
    $data['phone_number'],
    $data['gender'],
    $data['branch'], 
    $data['maritalStatus'],
    $data['bvn'], 
       $data['accountType'],
    $data['state'] 
);

// Execute the statement
if ($stmt->execute()) {
    echo json_encode([
        "ResponseCode" => "00",
        "ResponseMessage" => "Success"
    ]);
} else {
    echo json_encode([
        "ResponseCode" => "04",
        "ResponseMessage" => "Failed to insert data"
    ]);
}

// Close the statement and connection
$stmt->close();
$conn->close();
?>