<?php
// Enable error reporting for debugging purposes
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Include database connection file
include 'db.php';

// Set headers for JSON response
header('Content-Type: application/json');

// Retrieve the JSON request body
$json = file_get_contents('php://input');
$data = json_decode($json, true);

// Check if the JSON data is valid
if (json_last_error() !== JSON_ERROR_NONE) {
    echo json_encode([
        "ResponseCode" => "02",
        "ResponseMessage" => "Invalid JSON data"
    ]);
    exit;
}

// Check if all required parameters are provided
if (!isset($data['password']) || !isset($data['mobile'])) {
    echo json_encode([
        "ResponseCode" => "03",
        "ResponseMessage" => "Missing parameters"
    ]);
    exit;
}

// Extract data from the JSON object
$password = $data['password'];
$mobile = $data['mobile'];

// Prepare the SQL statement to check if the user exists using email, username, or mobile
$query = "SELECT userRole,firstname, lastname, password, username, age, blood_type, role,  weight,  height FROM users WHERE (mobile = ? ) LIMIT 1";
$check_user_stmt = $conn->prepare($query);
if (!$check_user_stmt) {
    echo json_encode([
        "ResponseCode" => "01",
        "ResponseMessage" => "Preparation of the user check statement failed: " . $conn->error
    ]);
    exit;
}

// Bind parameters
$check_user_stmt->bind_param("s", $mobile);
//$check_user_stmt->bind_param("sss", $user, $user, $user);
// Execute the statement
$check_user_stmt->execute();

// Bind the result and select user details from Table
$check_user_stmt->bind_result($userRole,$firstname, $lastname,$storedPassword,$username,$age, $blood_type, $role, $weight, $height);

// Fetch the result
if ($check_user_stmt->fetch()) {
    // Verify the password
    if ($password === $storedPassword) {
        echo json_encode([
            "ResponseCode" => "00",
            "ResponseMessage" => "Login successful",
            "mobile" => $mobile,
              "firstname" => $firstname,
              "lastname" => $lastname,
             "userRole" => $userRole,
               "username" => $username,
            "age" => $age,
              "blood_type" => $blood_type,
              "role" => $role,
                           "height" => $height,
               "weight" => $weight
               
        ]);
    } else {
        echo json_encode([
            "ResponseCode" => "01",
            "ResponseMessage" => "Invalid credentials"
        ]);
    }
} else {
    echo json_encode([
        "ResponseCode" => "02",
        "ResponseMessage" => "Invalid credentials"
    ]);
}

$check_user_stmt->close();
$conn->close();
?>
