<?php
// Enable error reporting for debugging purposes
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Include database connection file
include 'db.php';

// Set headers for JSON response
header('Content-Type: application/json');

// Retrieve the JSON request body
$json = file_get_contents('php://input');
$data = json_decode($json, true);

// Check if the JSON data is valid
if (json_last_error() !== JSON_ERROR_NONE) {
    echo json_encode([
        "ResponseCode" => "02",
        "ResponseMessage" => "Invalid JSON data"
    ]);
    exit;
}

// Check if all required parameters are provided
if (!isset($data['mobile']) || !isset($data['otp'])) {
    echo json_encode([
        "ResponseCode" => "03",
        "ResponseMessage" => "Missing parameters"
    ]);
    exit;
}

// Extract data from the JSON object
$mobile = $data['mobile'];
$otp = $data['otp'];

// Update the active field to 1 for any existing records with the same mobile number
$update_query = "UPDATE otp_request SET active = 1 WHERE mobile = ?";
$update_stmt = $conn->prepare($update_query);
if (!$update_stmt) {
    echo json_encode([
        "ResponseCode" => "01",
        "ResponseMessage" => "Preparation of the active update statement failed: " . $conn->error
    ]);
    exit;
}
$update_stmt->bind_param("s", $mobile);
$update_stmt->execute();
$update_stmt->close();

// Prepare the SQL statement to insert the OTP request
$query = "INSERT INTO otp_request (mobile, otp, active, created_at) VALUES (?, ?, 0, NOW())";
$insert_stmt = $conn->prepare($query);
if (!$insert_stmt) {
    echo json_encode([
        "ResponseCode" => "01",
        "ResponseMessage" => "Preparation of the OTP insert statement failed: " . $conn->error
    ]);
    exit;
}

// Bind parameters
$insert_stmt->bind_param("ss", $mobile, $otp);

// Execute the statement
if ($insert_stmt->execute()) {
    echo json_encode([
        "ResponseCode" => "00",
        "ResponseMessage" => "OTP request successful"
    ]);
} else {
    echo json_encode([
        "ResponseCode" => "01",
        "ResponseMessage" => "Failed to insert OTP request: " . $insert_stmt->error
    ]);
}

$insert_stmt->close();
$conn->close();
?>