<?php
// Enable error reporting for debugging purposes
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Include database connection file
include 'db.php';

// Set headers for JSON response
header('Content-Type: application/json');

// Retrieve the JSON request body
$json = file_get_contents('php://input');
$data = json_decode($json, true);

// Check if the JSON data is valid
if (json_last_error() !== JSON_ERROR_NONE) {
    echo json_encode([
        "ResponseCode" => "02",
        "ResponseMessage" => "Invalid JSON data"
    ]);
    exit;
}

// Check if 'mobile' and 'otp' parameters are provided
if (!isset($data['mobile']) || !isset($data['otp'])) {
    echo json_encode([
        "ResponseCode" => "03",
        "ResponseMessage" => "Missing parameters"
    ]);
    exit;
}

// Extract data from the JSON object
$mobile = $data['mobile'];
$otp = $data['otp'];

// Prepare the SQL statement to check if the mobile number exists in user_v2 table
$check_user_stmt = $conn->prepare("SELECT id FROM users_v2 WHERE mobile = ?");
if (!$check_user_stmt) {
    echo json_encode([
        "ResponseCode" => "01",
        "ResponseMessage" => "Preparation of the user check statement failed: " . $conn->error
    ]);
    exit;
}

// Bind parameters
$check_user_stmt->bind_param("s", $mobile);

// Execute the statement
$check_user_stmt->execute();

// Store the result
$check_user_stmt->store_result();

// Check if any records found
if ($check_user_stmt->num_rows > 0) {
    echo json_encode([
        "ResponseCode" => "03",
        "ResponseMessage" => "account with this mobile number already exist"
    ]);
    $check_user_stmt->close();
    $conn->close();
    exit;
}

$check_user_stmt->close();

// Prepare the SQL statement to mark existing OTPs as inactive
$update_stmt = $conn->prepare("UPDATE otp_request SET active = 1 WHERE mobile = ? AND active = 0");
if (!$update_stmt) {
    echo json_encode([
        "ResponseCode" => "01",
        "ResponseMessage" => "Preparation of the update statement failed: " . $conn->error
    ]);
    exit;
}

// Bind parameters
$update_stmt->bind_param("s", $mobile);

// Execute the update statement
if (!$update_stmt->execute()) {
    echo json_encode([
        "ResponseCode" => "01",
        "ResponseMessage" => "Updating existing OTPs failed: " . $update_stmt->error
    ]);
    $update_stmt->close();
    $conn->close();
    exit;
}
$update_stmt->close();

// Prepare the SQL statement to insert the new OTP
$insert_stmt = $conn->prepare("INSERT INTO otp_request (mobile, otp, active, created_at) VALUES (?, ?, 0, NOW())");
if (!$insert_stmt) {
    echo json_encode([
        "ResponseCode" => "01",
        "ResponseMessage" => "Preparation of the insert statement failed: " . $conn->error
    ]);
    exit;
}

// Bind parameters
$insert_stmt->bind_param("ss", $mobile, $otp);

// Execute the insert statement and check for errors
if ($insert_stmt->execute()) {
    echo json_encode([
        "ResponseCode" => "00",
        "ResponseMessage" => "successful"
    ]);
} else {
    echo json_encode([
        "ResponseCode" => "01",
        "ResponseMessage" => "Insert failed: " . $insert_stmt->error
    ]);
}

$insert_stmt->close();
$conn->close();
?>