<?php
// Enable error reporting for debugging purposes
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Include database connection file
include 'db.php';

// Set headers for JSON response
header('Content-Type: application/json');

// Retrieve the JSON request body
$json = file_get_contents('php://input');
$data = json_decode($json, true);

// Check if the JSON data is valid
if (json_last_error() !== JSON_ERROR_NONE) {
    echo json_encode([
        "ResponseCode" => "02",
        "ResponseMessage" => "Invalid JSON data"
    ]);
    exit;
}

// Check if all required parameters are provided
if (!isset($data['mobile']) || !isset($data['password'])) {
    echo json_encode([
        "ResponseCode" => "03",
        "ResponseMessage" => "Missing parameters"
    ]);
    exit;
}

// Extract data from the JSON object
$mobile = $data['mobile'];
$password = $data['password'];

// Prepare the SQL statement to update the password
$query = "UPDATE users_v2 SET password = ? WHERE mobile = ?";
$update_password_stmt = $conn->prepare($query);
if (!$update_password_stmt) {
    echo json_encode([
        "ResponseCode" => "01",
        "ResponseMessage" => "Preparation of the password update statement failed: " . $conn->error
    ]);
    exit;
}

// Bind parameters
$update_password_stmt->bind_param("ss", $password, $mobile);

// Execute the statement
if ($update_password_stmt->execute()) {
    if ($update_password_stmt->affected_rows > 0) {
        echo json_encode([
            "ResponseCode" => "00",
            "ResponseMessage" => "Password updated successfully"
        ]);
    } else {
        echo json_encode([
            "ResponseCode" => "01",
            "ResponseMessage" => "No user found with the provided mobile number"
        ]);
    }
} else {
    echo json_encode([
        "ResponseCode" => "01",
        "ResponseMessage" => "Failed to update password: " . $update_password_stmt->error
    ]);
}

$update_password_stmt->close();
$conn->close();
?>