<?php
header("Content-Type: application/json");

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405); // Method Not Allowed
    echo json_encode(["error" => "Only POST method is allowed."]);
    exit;
}

// Database configuration
$host = 'localhost'; 
$dbname = 'hgtng_mamaspad';
$username = 'hgtng_mamaspad';
$password = 'Mamaspad2025++';

try {
    // Create a new PDO instance
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    http_response_code(500); // Internal Server Error
    echo json_encode(["error" => "Database connection failed."]);
    exit;
}

// Generate a 6-digit OTP
function generateOTP() {
   // return random_int(100000, 999999);
   return 123456;
}

// Send OTP via REST API
function sendOTP($otp, $phoneNumber) {
    $apiUrl = "https://www.bulksmsnigeria.com/api/v1/sms/create"; // Replace with your API URL
    $apiToken = "qxC0iewSDshSAsXRW8ieA0fqtrOMnmxq9QyUr2gy09V9aq2BOiEppZqX3Ubk";
    $sender = "HGT";

    $body = "Hello use {$otp} to complete your request";

    // API payload
    $payload = [
        "api_token" => $apiToken,
        "from" => $sender,
        "to" => $phoneNumber,
        "body" => $body,
    ];

    // cURL initialization
    $ch = curl_init($apiUrl);

    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
    ]);

    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        throw new Exception("cURL error: " . curl_error($ch));
    }

    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    curl_close($ch);

    if ($httpCode !== 200) {
        throw new Exception("API request failed with response: $response");
    }

    return json_decode($response, true);
}

// Update or insert OTP in database
function handleOTP($pdo, $phoneNumber, $otp) {
    // Check if record exists with active = 0 for the given mobile number
    $checkSql = "SELECT * FROM otp_request WHERE mobile = :phone_number AND active = 0";
    $stmt = $pdo->prepare($checkSql);
    $stmt->execute(['phone_number' => $phoneNumber]);
    $record = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($record) {
        // Update the existing record to set active = 1
        $updateSql = "UPDATE otp_request SET active = 1 WHERE mobile = :phone_number AND active = 0";
        $updateStmt = $pdo->prepare($updateSql);
        $updateStmt->execute(['phone_number' => $phoneNumber]);
    }

    // Insert a new record with active = 0
    $insertSql = "INSERT INTO otp_request (mobile, otp, active, created_at) VALUES (:phone_number, :otp, 0, NOW())";
    $insertStmt = $pdo->prepare($insertSql);
    $insertStmt->execute([
        'phone_number' => $phoneNumber,
        'otp' => $otp,
    ]);
}

// Handle the incoming request
try {
    $input = json_decode(file_get_contents("php://input"), true);

    if (!isset($input['mobile']) || empty($input['mobile'])) {
        http_response_code(400); // Bad Request
        echo json_encode(["error" => "Mobile number is required."]);
        exit;
    }

    $mobile = $input['mobile'];
    if (!preg_match('/^\d{11}$/', $mobile)) { // Validate Nigerian mobile numbers
        http_response_code(400); // Bad Request
        echo json_encode(["error" => "Invalid mobile number format."]);
        exit;
    }

    //$phoneNumber = "234" . substr($mobile, 1); // Convert to international format

    $phoneNumber = $mobile;
    $otp = generateOTP();

    // Send OTP via API to BULK SMS Service
   // $apiResponse = sendOTP($otp, $phoneNumber);

    // Handle OTP storage and updates
    handleOTP($pdo, $phoneNumber, $otp);

    // Respond with success
    http_response_code(200); // OK
    echo json_encode([
        "ResponseCode" => "00",
        "message" => "OTP sent successfully.",
        "otp" => $otp // Optionally include OTP in response for testing purposes
    ]);
} catch (Exception $e) {
    http_response_code(500); // Internal Server Error
    echo json_encode(["error" => $e->getMessage()]);
}
?>