<?php
// Enable error reporting for debugging purposes
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Include database connection file
include 'db.php';  // Ensure you have your database connection in 'db.php'

// Set headers for JSON response
header('Content-Type: application/json');

// Retrieve the JSON request body
$json = file_get_contents('php://input');
$data = json_decode($json, true);

// Check if the JSON data is valid
if (json_last_error() !== JSON_ERROR_NONE) {
    echo json_encode([
        "ResponseCode" => "02",
        "ResponseMessage" => "Invalid JSON data"
    ]);
    exit;
}

// Check if the email field is present
if (!isset($data['email'])) {
    echo json_encode([
        "ResponseCode" => "03",
        "ResponseMessage" => "Missing 'email' parameter"
    ]);
    exit;
}

// Get the email from the request
$email = $data['email'];

// Prepare the SQL query to get the last 10 transactions based on email
$query = "SELECT dollar_unit, amount_in_naira, transaction_date, transaction_time, item 
          FROM transaction_list 
          WHERE email = ? 
          ORDER BY transaction_date DESC, transaction_time DESC 
          LIMIT 10";

$stmt = $conn->prepare($query);
$stmt->bind_param("s", $email);
$stmt->execute();

// Get the result
$result = $stmt->get_result();

// Check if any transactions are found
if ($result->num_rows > 0) {
    $transactions = [];

    // Fetch all the rows as an associative array
    while ($row = $result->fetch_assoc()) {
        $transactions[] = $row;
    }

    // Return the transactions in the response
    echo json_encode([
        "ResponseCode" => "00",
        "ResponseMessage" => "Success",
        "transactions" => $transactions
    ]);
} else {
    // If no transactions found, return an empty list
    echo json_encode([
        "ResponseCode" => "01",
        "ResponseMessage" => "No transactions found",
        "transactions" => []
    ]);
}

// Close the statement and connection
$stmt->close();
$conn->close();
?>
