<?php
// Enable error reporting for debugging
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Include database connection file
include 'db.php'; // Ensure you have your database connection in 'db.php'

// Set headers for JSON response
header('Content-Type: application/json');

// Retrieve the JSON request body
$json = file_get_contents('php://input');
$data = json_decode($json, true);

// Check if the JSON data is valid
if (json_last_error() !== JSON_ERROR_NONE) {
    echo json_encode([
        "ResponseCode" => "02",
        "ResponseMessage" => "Invalid JSON data"
    ]);
    exit;
}

// Validate the required fields
if (!isset($data['mobile']) || !isset($data['email']) || !isset($data['dollar_unit']) || !isset($data['amount_in_naira'])) {
    echo json_encode([
        "ResponseCode" => "03",
        "ResponseMessage" => "Missing required parameters"
    ]);
    exit;
}

// Get the input data
$mobile = $data['mobile'];
$email = $data['email'];
$dollar_unit = $data['dollar_unit'];
$amount_in_naira = $data['amount_in_naira'];
$item = $data['item'];

// Capture the current date and time for the transaction
$transaction_date = date("Y-m-d"); // Current date in YYYY-MM-DD format
$transaction_time = date("H:i:s"); // Current time in HH:MM:SS format

// Prepare the SQL query to insert the transaction
$query = "INSERT INTO transaction_list (mobile, email, dollar_unit, amount_in_naira, transaction_date, transaction_time,item)
          VALUES (?, ?, ?, ?, ?, ?, ?)";

// Use prepared statements to prevent SQL injection
$stmt = $conn->prepare($query);
$stmt->bind_param("sssssss", $mobile, $email, $dollar_unit, $amount_in_naira, $transaction_date, $transaction_time, $item);

// Execute the query
if ($stmt->execute()) {
    // If the transaction is inserted successfully, return a success response
    echo json_encode([
        "ResponseCode" => "00",
        "ResponseMessage" => "Transaction successfully posted"
    ]);
} else {
    // If there's an error during the insert, return an error response
    echo json_encode([
        "ResponseCode" => "01",
        "ResponseMessage" => "Failed to post transaction"
    ]);
}

// Close the statement and connection
$stmt->close();
$conn->close();
?>
