<?php
// Enable error reporting for debugging purposes
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Include database connection file
include 'db.php';

// Set headers for JSON response
header('Content-Type: application/json');

// Retrieve the JSON request body
$json = file_get_contents('php://input');
$data = json_decode($json, true);

// Check if the JSON data is valid
if (json_last_error() !== JSON_ERROR_NONE) {
    echo json_encode([
        "ResponseCode" => "02",
        "ResponseMessage" => "Invalid JSON data"
    ]);
    exit;
}

// Check if 'mobile' and 'otp' parameters are provided
if (!isset($data['age']) || !isset($data['blood_type']) || !isset($data['role']) || !isset($data['weight']) || !isset($data['height']) || !isset($data['mobile'])) {
    echo json_encode([
        "ResponseCode" => "03",
        "ResponseMessage" => "Missing parameters"
    ]);
    exit;
}

// Extract data from the JSON object
$age = $data['age'];
$blood_type = $data['blood_type'];
$role = $data['role'];
$weight = $data['weight'];
$height = $data['height'];
$mobile = $data['mobile'];

// Prepare the SQL statement to validate OTP
$stmt = $conn->prepare("SELECT id FROM users WHERE mobile = ? ");

// Check if the statement was prepared successfully
if (!$stmt) {
    echo json_encode([
        "ResponseCode" => "01",
        "ResponseMessage" => "Preparation of the statement failed: " . $conn->error
    ]);
    exit;
}

// Bind parameters
$stmt->bind_param("s", $mobile);

// Execute the statement
$stmt->execute();

// Store the result
$stmt->store_result();

// Check if an OTP record was found
if ($stmt->num_rows > 0) {
    // Mark the OTP as used (active = 1)
    $stmt_update = $conn->prepare("UPDATE users SET age ='$age' , blood_type ='$blood_type' , role ='$role' , weight ='$weight' , height ='$height' WHERE mobile = ? ");
    $stmt_update->bind_param("s", $mobile);
    $stmt_update->execute();
    $stmt_update->close();

    echo json_encode([
        "ResponseCode" => "00",
        "ResponseMessage" => "Vitals update successful"
    ]);
} else {
    echo json_encode([
        "ResponseCode" => "01",
        "ResponseMessage" => "Vitals update failed"
    ]);
}

$stmt->close();
$conn->close();
?>